/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public class UpdateModifiersPacket
implements IThreadsafePacket {
    private final Map<ModifierId, Modifier> allModifiers;
    private Collection<Modifier> modifiers;
    private Map<ModifierId, ModifierId> redirects;

    public UpdateModifiersPacket(Map<ModifierId, Modifier> map) {
        this.allModifiers = map;
    }

    private void ensureCalculated() {
        if (this.modifiers == null || this.redirects == null) {
            ImmutableList.Builder modifiers = ImmutableList.builder();
            ImmutableMap.Builder redirects = ImmutableMap.builder();
            for (Map.Entry<ModifierId, Modifier> entry : this.allModifiers.entrySet()) {
                Modifier mod;
                ModifierId id = entry.getKey();
                if (id.equals((Object)(mod = entry.getValue()).getId())) {
                    modifiers.add((Object)mod);
                    continue;
                }
                redirects.put((Object)id, (Object)mod.getId());
            }
            this.modifiers = modifiers.build();
            this.redirects = redirects.build();
        }
    }

    public UpdateModifiersPacket(FriendlyByteBuf buffer) {
        int i;
        int size = buffer.m_130242_();
        HashMap<ModifierId, Modifier> modifiers = new HashMap<ModifierId, Modifier>();
        for (i = 0; i < size; ++i) {
            ModifierId id = new ModifierId(buffer.m_130136_(Short.MAX_VALUE));
            Modifier modifier = (Modifier)ModifierManager.MODIFIER_LOADERS.fromNetwork(buffer);
            modifier.setId(id);
            modifiers.put(id, modifier);
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ModifierId from = new ModifierId(buffer.m_130136_(Short.MAX_VALUE));
            ModifierId to = new ModifierId(buffer.m_130136_(Short.MAX_VALUE));
            Modifier modifier = ModifierManager.INSTANCE.getStatic(to);
            if (modifier == ModifierManager.INSTANCE.getDefaultValue() && (modifier = (Modifier)modifiers.get((Object)to)) == null) {
                throw new DecoderException("Unknown modifier " + to);
            }
            modifiers.put(from, modifier);
        }
        this.allModifiers = modifiers;
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ensureCalculated();
        buffer.m_130130_(this.modifiers.size());
        for (Modifier modifier : this.modifiers) {
            buffer.m_130085_((ResourceLocation)modifier.getId());
            ModifierManager.MODIFIER_LOADERS.toNetwork((GenericLoaderRegistry.IHaveLoader)modifier, buffer);
        }
        buffer.m_130130_(this.redirects.size());
        for (Map.Entry entry : this.redirects.entrySet()) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130085_((ResourceLocation)entry.getValue());
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ModifierManager.INSTANCE.updateModifiersFromServer(this.allModifiers);
    }
}

